import sys, socket, threading

keep_running = False
buffer_size = 1024

# NOTE: this is a sample, a basic idea of how to write an IO thread
# that terminates cleanly. Your application will probably want to do
# things slightly differently for one reason or another, but this is
# the general idea
class IOTask (threading.Thread):

    def __init__(self, sock):
        threading.Thread.__init__(self)
        self.sock = sock
        self.keep_running = True

    def run(self):
        # run until self.keep_running is false
        while (self.keep_running):
            # NOTE: this is blocking, there's no "easy" way to do
            # non-blocking reads from stdin. If you really really need
            # to there are workarounds out there.
            line = sys.stdin.readline()
            # detect EOF as a blank line and set self.keep_running to false
            if line == "":
                self.keep_running = False
            else:
                print line
                try:
                    self.sock.send(line)
                except Exception:
                    print "Failed to send (is the server up?)"

    def stop(self):
        self.keep_running = False

# NOTE: this is a sample, a basic idea of how to write a receiver
# thread on a UDP socket with timeout. Your application will probably
# want to do things slightly differently for one reason or another,
# but this is the general idea
class UDPTask (threading.Thread):
    def __init__(self, sock):
        threading.Thread.__init__(self)
        self.sock = sock
        self.keep_running = True

    def run(self):
        # run until self.keep_running is changed
        while (self.keep_running):
            try:
                output = sock.recv(buffer_size).strip()
            except Exception, e:
                # going to be catching an exception every time the socket times out
                continue

    def stop(self):
        self.keep_running = False

# Main Code
# NOTE: this is just some sample code, your application will probably
# be very different (unless you're redoing project 0): the main things
# to see are how the threads are made and properly ended using join()
# and signals.
try:
    hostname = sys.argv[1]
    port = int(sys.argv[2])
    sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    hostip = socket.gethostbyname(hostname)

    print "Connecting to ", hostname + "/" + hostip + ":" + str(port)

    my_ip = socket.gethostbyname(socket.gethostname())
    # give the socket a timeout so our thread won't hang
    sock.settimeout(0.01)
    sock.bind((my_ip, port))
    sock.connect((hostip, port))
    sock.send(my_ip + " " + str(port) + "\n")

    # Start the IOTask
    io_thread = IOTask(sock)
    io_thread.start()
  
    # Start the UDPTask
    udp_thread = UDPTask(sock)
    udp_thread.start()
    
    # Wait for IOTask to finish
    io_thread.join()

    # Signal udp_thread to stop
    udp_thread.stop()

    # Wait for udp_thread to stop
    udp_thread.join()
   
    print "done"
except Exception as e:
    print e
