import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

/***
 * This is a sample of a basic UDP receiver thread on a socket with timeout.
 * Your own application will probably need to do things a bit different but this
 * is the general idea
 * 
 * @author plvines
 * 
 */
public class UDPTask implements Runnable {
	final DatagramSocket socket;

	final int buffer_size;

	boolean keepRunning;

	public UDPTask(DatagramSocket socket, int buffer_size) {
		this.socket = socket;
		this.buffer_size = buffer_size;
	}

	@Override
	public void run() {
		keepRunning = true;
		DatagramPacket packet = new DatagramPacket(new byte[buffer_size],
				buffer_size);

		// Set a timeout so we won't block waiting for another packet
		try {
			socket.setSoTimeout(100);
		} catch (SocketException e1) {
			e1.printStackTrace();
		}

		// Run until keepRunning toggles
		while (keepRunning) {
			try {
				socket.receive(packet);
			} catch (java.net.SocketTimeoutException e) {
				// Throw's this every time we timeout, but we don't care
			} catch (IOException e) {
				e.printStackTrace();
			}

		}

	}

}
