import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;

/***
 * This is a sample. Your application code is going to be significantly
 * different (unless you're redoing project 0) but the things to note here are
 * how the threads are made and that they are correctly exited using join() and
 * signals
 * 
 * @author plvines
 * 
 */
public class ThreadHandler {

	final static int BUFFER_SIZE = 1024;

	public static void main(String[] args) {
		DatagramSocket socket;
		try {

			// Setup and send first message to server
			socket = new DatagramSocket();
			String addr = args[0];
			int port = Integer.parseInt(args[1]);

			InetAddress host = InetAddress.getByName(addr);
			System.out.println("Connecting to: " + host + ":" + port);

			byte[] data = (InetAddress.getLocalHost().getHostAddress() + " " + socket
					.getLocalPort()).getBytes();

			DatagramPacket request = new DatagramPacket(data, data.length,
					host, port);

			socket.send(request);

			// Start IOTask thread
			IOTask ioTask = new IOTask(socket, host, port);
			Thread ioThread = new Thread(ioTask);
			ioThread.start();

			// Start UDPTask thread
			UDPTask udpTask = new UDPTask(socket, BUFFER_SIZE);
			Thread udpThread = new Thread(udpTask);
			udpThread.start();

			// Main thread waits until IO thread ends
			ioThread.join();

			// Signal udpThread task to stop
			udpTask.keepRunning = false;

			// Wait for udpThread to finish
			udpThread.join();

			// Clean up socket and print done
			socket.close();
			System.out.println("Done");

		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
