import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

/**
 * This is a sample of a basic IO thread. Your own application will probably
 * want to do things slightly differently, but the general idea should be the
 * same
 * 
 * @author plvines
 * 
 */
public class IOTask implements Runnable {

	boolean keepRunning;
	DatagramSocket socket;
	InetAddress host;
	int port;

	public IOTask(DatagramSocket socket, InetAddress host, int port) {
		this.socket = socket;
		this.host = host;
		this.port = port;
	}

	@Override
	public void run() {

		// Set up variables used in the run-loop
		this.keepRunning = true;
		BufferedReader input = new BufferedReader(new InputStreamReader(
				System.in));
		DatagramPacket packet;
		String line = "";

		// Run until keepRunning toggles
		while (keepRunning) {
			try {
				// Check if there's something to read yet
				if (input.ready()) {
					line = input.readLine();

					// If EOF then line will be null
					if (line == null) {
						keepRunning = false;
					}
					// Otherwise send and print the line
					else {
						packet = new DatagramPacket(line.getBytes(),
								line.getBytes().length, host, port);
						socket.send(packet);
						System.out.println(line);
					}
				} else {
					// Nothing was ready to be read in Input, so let's sleep
					try {
						Thread.sleep(100);
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

		try {
			input.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

	}
}
