#!/bin/bash
#NOTE: DO NOT EDIT THIS FILE-- MAY RESULT IN INCOMPLETE SUBMISSIONS
set -euo pipefail

CODE=(
    "segmentation.py"
    "images/color_position_features.png"
    "utils.py"
    "transformation.gif"  
    "train.jpg"
    "solution_transformation.gif"
    "palace.jpg"
    "cameras.py"
    "images/color_features.png"
    "images/pressure_cooker.jpg"
    "images/vanishing_point_reference.png"
    "images/projection_geometry.png"
    "images/vanishing_point.jpg"
    "data/imgs/tortoiseshell_shell_cat.jpg"
    "data/imgs/cat_mouse.jpg"
    "data/imgs/cutest-cat-ever-snoopy-sleeping.jpg"
    "data/imgs/the-black-white-kittens.jpg"
    "data/imgs/cat_bed.jpg"
    "data/imgs/stripey-kitty.jpg"
    "data/imgs/grey-american-shorthair.jpg"
    "data/imgs/kitten9.jpg"
    "data/imgs/black_kitten.jpg"
    "data/imgs/grey-cat-grass.jpg"
    "data/imgs/black_kitten_star.jpg"
    "data/imgs/kitten16.jpg"
    "data/imgs/black-white-kittens2.jpg"
    "data/imgs/cat_grumpy.jpg"
    "data/imgs/young-calico-cat.jpg"
    "data/imgs/cat-jumping-running-grass.jpg"
    "data/gt/cutest-cat-ever-snoopy-sleeping.png"
    "data/gt/kitten16.png"
    "data/gt/stripey-kitty.png"
    "data/gt/the-black-white-kittens.png"
    "data/gt/cat_bed.png"
    "data/gt/grey-cat-grass.png"
    "data/gt/cat-jumping-running-grass.png"
    "data/gt/tortoiseshell_shell_cat.png"
    "data/gt/cat_mouse.png"
    "data/gt/black_kitten_star.png"
    "data/gt/young-calico-cat.png"
    "data/gt/cat_grumpy.png"
    "data/gt/black-white-kittens2.png"
    "data/gt/black_kitten.png"
    "data/gt/kitten9.png"
    "data/gt/grey-american-shorthair.png"
)

# these notebooks should ideally
# be in order of questions so
# that the generated pdf is
# in order of questions
NOTEBOOKS=(
	"Segmentation.ipynb"
	"Cameras.ipynb"

)

FILES=( "${CODE[@]}" "${NOTEBOOKS[@]}" )

LOCAL_DIR=`pwd`
ASSIGNMENT_NO=3
ZIP_FILENAME="a3_code_submission.zip"
PDF_FILENAME="a3_inline_submission.pdf"

C_R="\e[31m"
C_G="\e[32m"
C_BLD="\e[1m"
C_E="\e[0m"

for FILE in "${FILES[@]}"
do
	if [ ! -f ${FILE} ]; then
		echo -e "${C_R}Required file ${FILE} not found, Exiting.${C_E}"
		exit 0
	fi
done

echo -e "### Zipping file ###"
rm -f ${ZIP_FILENAME}
zip -q "${ZIP_FILENAME}" -r ${NOTEBOOKS[@]} $(find . -name "*.py") -x "makepdf.py"

echo -e "### Creating PDFs ###"
python makepdf.py --notebooks "${NOTEBOOKS[@]}" --pdf_filename "${PDF_FILENAME}"

echo -e "### Done! Please submit ${ZIP_FILENAME} and ${PDF_FILENAME} to Gradescope. ###"
