// StarterSat4j.java
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ISolver;
import org.sat4j.core.VecInt;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.TimeoutException;

public class SudokuSolver {

    // creates a sat instance using the given sudoku puzzle, solves that instance, 
    // then uses the solution to construct and return a solved puzzle
    // returns null if the puzzle cannot be solved
    public static Sudoku solveSudoku(Sudoku sudo){
        ISolver solver = buildSolver(sudo); //invokes your solver code
        int boardSize = sudo.getBoard().length; // gets the board size
        try{
            boolean isSat = solver.isSatisfiable(); // check that the formula is satisfiabl
            if(isSat){ // if so
                int[] model = solver.model(); // get the true variables
                return buildSolution(boardSize, model); // call your code to construct the solved puzzle, returning the result
            }
        } catch (TimeoutException te) { // solving the SAT instance may time out, if so then it throws an exception
                                            // If your code times out, you can try changing the timeout length
                                            // but more likely your formula is unneccessarily long.
            System.out.println("Solving timed out: " + te.getMessage());
        }
        return null; // return null if the puzzle is not solvable (we do not test your code on any such puzzles)
    }

    private static ISolver buildSolver(Sudoku sudo){
        //TODO
        ISolver solver = SolverFactory.newDefault(); // create an ISolver
        solver.setTimeout(5); // set the timeout to 5 seconds, you may change this but likely won't need to
        int[][] board = sudo.getBoard(); // get the contents of the puzzle, you'll use this to build your SAT formula
        int boardSize = board.length; // the size of the board
        int n = (int) Math.sqrt(boardSize);  // the value of n in the problem definition, i.e. the square root of the board size
        // you will start writing your code here to add clauses to the solver
        return solver; // return the formula when done.
    }


    // use the assignments of true/false to each variable to construct
    // a solved sudoku puzzle by filling in a 2d array of numbers.
    public static Sudoku buildSolution(int boardSize, int[] model){
        //TODO
        return null;
    }
}
