import java.util.*;

public class Shannon extends PrefixFreeEncoder{
    
    public Shannon(String message){
        super(message);
    }

    public Shannon(int[] frequencies, char[] indexToChar){
        super(frequencies, indexToChar);
    }

    public void buildTable(){
        Queue<CharFreqPair> pq = new PriorityQueue<>();
        int totalChars = 0;
        for(int i=0; i < frequencies.length; i++){
            pq.add(new CharFreqPair(i, frequencies[i]));
            totalChars += frequencies[i];
        }
        String codeWord = "";
        while(!pq.isEmpty()){
            CharFreqPair cfp = pq.remove();
            int codeLength = codeLength((1.0*cfp.f)/totalChars);
            if(codeWord.length() != codeLength){
                codeWord = "";
                for(int j = 0; j < codeLength; j++){   
                    codeWord += '0';
                }
            }
            codeWord = selectEncoding(codeWord);
            encodingTable[cfp.c] = codeWord;
        }
    }

    private static int codeLength(double frequencyRatio){
        return (int) Math.ceil(Math.log(1/frequencyRatio) / Math.log(2));
    }

    private String nextCodeWord(String prevCodeWord){
        if(prevCodeWord.length() == 0){
            return "";
        }
        if(prevCodeWord.charAt(prevCodeWord.length()-1) == '0'){
            return prevCodeWord.substring(0, prevCodeWord.length()-1) + '1';
        }
        return nextCodeWord(prevCodeWord.substring(0, prevCodeWord.length()-1)) + '0';
    }

    private boolean prefixUsed(String codeWord){
        for(int i = 0; i < encodingTable.length; i++){
            if(encodingTable[i] != null){
                if(codeWord.substring(0, encodingTable[i].length()).equals(encodingTable[i])){
                    return true;
                }
            }
        }
        return false;
    }

    private String selectEncoding(String prevCodeWord){
        while(prefixUsed(prevCodeWord)){
            prevCodeWord = nextCodeWord(prevCodeWord);
        }
        return prevCodeWord;
    }

    private class CharFreqPair implements Comparable<CharFreqPair>{
        public int c;
        public int f;

        public CharFreqPair(int c, int f){
            this.c = c;
            this.f = f;
        }

        public int compareTo(CharFreqPair other){
            return other.f - this.f;
        }

    }
}
