import java.util.*;

public class Huffman extends PrefixFreeEncoder{

    HuffNode root;

    public Huffman(String message){
        super(message);
    }

    public Huffman(int[] frequencies, char[] indexToChar){
        super(frequencies, indexToChar);
    }

    public void buildTable(){
        Queue<HuffNode> pq = new PriorityQueue<>();
        for(int i = 0; i < frequencies.length; i++){
            pq.add(new HuffNode(i, frequencies[i]));
        }
        while(pq.size() > 1){
            HuffNode first = pq.remove();
            HuffNode second = pq.remove();
            HuffNode parent = new HuffNode(first, second);
            pq.add(parent);
        }
        this.root = pq.remove();
        populateTable(this.root, "");
    }

    private void populateTable(HuffNode curr, String prefix){
        if(curr != null){
            if(curr.c > -1){
                encodingTable[curr.c] = prefix;
            } else{
                populateTable(curr.left, prefix+"0");
                populateTable(curr.right, prefix+"1");
            }
        }
    }

    private class HuffNode implements Comparable<HuffNode>{
        int c;
        int frequency;
        HuffNode left;
        HuffNode right;

        public HuffNode(int c, int frequency){
            this.c = c;
            this.frequency = frequency;
            left = null;
            right = null;
        }

        public HuffNode(HuffNode left, HuffNode right){
            this.c = -1;
            frequency = left.frequency + right.frequency;
            this.left = left;
            this.right = right;
        }

        public int compareTo(HuffNode other){
            return this.frequency - other.frequency;
        }
    }
}