import java.util.*;

public class Clusterer {
    private List<CoordinatePair> points;
    private List<List<Edge>> adjList; // the adjacency list of the original graph
    private List<List<Edge>> mstAdjList; // the adjacency list of the minimum spanning tree
    private List<List<CoordinatePair>> clusters; // a list of k points, each representing one of the clusters.
    private double cost; // the distance between the closest pair of clusters

    // goal: initalize graph with given parameters (points and k) to
    // construct adjacency list version of graph. 
    // Each point is a node in this graph. The result will be a
    // complete graph where the weight between two nodes is the distance
    // between the points.
    public Clusterer(List<CoordinatePair> points, int k){ // k = # of clusters
        //initalize lists
        this.points = new ArrayList<>(points);
        adjList = new ArrayList<>();
        mstAdjList = new ArrayList<>();
        clusters = new ArrayList<>();

        int n = points.size(); //n = # of points

        for(int i = 0; i < n; i++){
            adjList.add(new ArrayList<>());
            mstAdjList.add(new ArrayList<>());
        }

        // Initialize clusters
        for (int i = 0; i < k; i++) {
            clusters.add(new ArrayList<>());
        }

        // populate the graph - by creating Edge objects for each pair of points (i, j)
        for(int i = 0; i < n; i++){
            for (int j = 0; j < n; j++) {
                if (i != j) {
                    adjList.get(i).add(new Edge(i, j));
                }
            }
        }

        mst(); // your minimum spanning tree implementation
        makeKCluster(k); // use the minimum spanning tree to identify the clusters.
    }

    // goal: is to create an MST using Prim's or Kruskal's algorithm.
    // The resulting adjacency list representation of the MST will be
    // stored in the mstAdjList field.
    private void mst(){ 
        //TODO
    }

    


    // After making the minimum spanning tree, use this method to
    // divide the points into clusters.
    // The clusters should be the clusters field, which is
    // a list of list of CoordinatePairs.
    private void makeKCluster(int k){
        //TODO
    }

    // returns the list of list of coordinate pairs representing
    // the k clusters
    public List<List<CoordinatePair>> getClusters(){
        return clusters;
    }

    // returns the cost of the clustering, specifically the distance
    // between the closest two clusters (defined to be the distance
    // between the closest two points from within the clusters)
    public double getCost(){
        return cost;
    }


    // A private inner class representing a weighted edge.
    // This is helpful for succinctly representing the weighted graph
    // as an adjacency list.
    // The end points of the edge are represented by their index in
    // the points field of the Clusterer object. This is helpful for
    // looking up specific points from the graph in constant time.
    private class Edge implements Comparable<Edge>{
        double weight;
        int sourceIndex;
        int destinationIndex;

        public Edge(int sourceIndex, int destinationIndex){
            this.sourceIndex = sourceIndex;
            this.destinationIndex = destinationIndex;
            weight = points.get(sourceIndex).distance(points.get(destinationIndex));
        }

        public boolean equals(Object other){
            if (this == other) {
                return true;
            }
            if (other == null || getClass() != other.getClass()) {
                return false;
            }
            Edge otheredge = (Edge) other;
            return this.sourceIndex == otheredge.sourceIndex && this.destinationIndex == otheredge.destinationIndex;
        }

        public int compareTo(Edge other){
            if(this.weight < other.weight){
                return -1;
            }
            if(this.weight > other.weight){
                return 1;
            }
            return 0;
        }

        public String toString(){
            return "(" + points.get(sourceIndex) + "->" + points.get(destinationIndex) + "," + weight + ")"; 
        }
    }

}


