import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class Client {

    public static List<CoordinatePair> loadPoints(String filename){
        List<CoordinatePair> points = new ArrayList<>();
        File input = new File(filename);
        try(Scanner inputReader = new Scanner(input)){
            while(inputReader.hasNext()){
                String line = inputReader.nextLine();
                double x = Double.parseDouble(line.split(",")[0]);
                double y = Double.parseDouble(line.split(",")[1]);
                points.add(new CoordinatePair(x,y));
            }
        }
        catch (FileNotFoundException e){
            e.printStackTrace();
        }
        return points;
    }

    public static void main(String[] args){
        List<CoordinatePair> points = loadPoints("multigrid.csv");

        Clusterer cluster2 = new Clusterer(points, 2);
        Clusterer cluster4 = new Clusterer(points, 4);
        Clusterer cluster5 = new Clusterer(points, 5);
        System.out.println(cluster2.getCost());
        System.out.println(cluster4.getCost());
        System.out.println(cluster5.getCost());
        System.out.println(cluster5.getClusters());

        Plot.plot(cluster5.getClusters());
    }
}
