public class PointPair {
    private final CoordinatePair first;
    private final CoordinatePair second;

    public PointPair(CoordinatePair first, CoordinatePair second){
        this.first = first;
        this.second = second;
    }

    public CoordinatePair getFirst(){
        return this.first;
    }

    public CoordinatePair getSecond(){
        return this.second;
    }

    public String toString(){
        return "[" + this.first + this.second + "]";
    }

    public boolean equals(Object other){
        if (this == other) {
            return true;
        }
        if (other == null || getClass() != other.getClass()) {
            return false;
        }
        PointPair otherpair = (PointPair) other;
        return otherpair.first == this.first &&  otherpair.second == this.second 
               || otherpair.first == this.second &&  otherpair.second == this.first;
    }
}
