public class CoordinatePair {
    private final double x;
    private final double y;

    public CoordinatePair(double x, double y){
        this.x = x;
        this.y = y;
    }

    public double getX(){
        return this.x;
    }

    public double getY(){
        return this.y;
    }

    public String toString(){
        return "(" + x + "," + y + ")";
    }

    public boolean equals(Object other){
        if (this == other) {
            return true;
        }
        if (other == null || getClass() != other.getClass()) {
            return false;
        }
        CoordinatePair otherpair = (CoordinatePair) other;
        return otherpair.x == this.x &&  otherpair.y == this.y;
    }

    public double distance(CoordinatePair other){
        double dx = this.x - other.x;
        double dy = this.y - other.y;
        return Math.sqrt(dx*dx + dy*dy);
    }
}
