import java.io.File;
import java.io.FileNotFoundException;
import java.util.*;

public class Client{

    public static List<CoordinatePair> loadPoints(String filename){
        List<CoordinatePair> points = new ArrayList<>();
        File input = new File(filename);
        try(Scanner inputReader = new Scanner(input)){
            while(inputReader.hasNext()){
                String line = inputReader.nextLine();
                double x = Double.parseDouble(line.split(",")[0]);
                double y = Double.parseDouble(line.split(",")[1]);
                points.add(new CoordinatePair(x,y));
            }
        }
        catch (FileNotFoundException e){
            e.printStackTrace();
        }
        return points;
    }

    public static void main(String[] args){
        // If you want to test a particular list of points, do so here.
        // Make sure that your testPoints satisfy the conditions on distance and c.
        // See the spec for a recommended distance and c for each provided test file.
        // Note that the provided brute force solution does not care about c.
        List<CoordinatePair> testPoints = loadPoints("5linearpoints.csv");
        System.out.println(DivideAndConquer.closePairs(testPoints, 1.45, 3));
        System.out.println(BruteForce.closePairs(testPoints, 1.45));

        // If you want to test a random list of points, do so here.
        // The script generating random points uses distance = 0.5 and c = 40.
        testPoints = BenchMark.randomPoints(10);
        System.out.println(DivideAndConquer.closePairs(testPoints, 0.5, 40));
        System.out.println(BruteForce.closePairs(testPoints, 0.5));

        // Run your benchmark here by changing the list of sizes.
        // The output times are in nanoseconds.
        // Copy the output into a CSV file, or append "> output.csv" to
        // the end of the command that runs this file.
        List<Integer> sizes = new ArrayList<>(Arrays.asList(10, 10000));
        BenchMark.benchmarkAll(sizes);
    }

}