import java.util.*;

public class BenchMark {

    // This code generates random points in a square region such that 
    // every square of side length 2*distance has no more than c points.
    // This code also guarantees that no x- or y-coordinate is chosen twice.
    // On average, such squares will have about c/10 points. 
    //
    // This codes fixes distance = 0.5 and c = 40.
    public static List<CoordinatePair> randomPoints(int n){
        // Side length of grid
        double l = Math.ceil(Math.sqrt(n) / 2);

        List<CoordinatePair> points = new ArrayList<>();
        List<List<Integer>> peopleInCell = new ArrayList<>((int) l);
        for (int i = 0; i < l; i++) {
            List<Integer> row = new ArrayList<>(Collections.nCopies((int) l, 0));
            peopleInCell.add(row);
        }

        Set<Double> xChosen = new TreeSet<>();
        Set<Double> yChosen = new TreeSet<>();
        Random rand = new Random();

        while (points.size() < n){
            double x = rand.nextDouble()*l;
            double y = rand.nextDouble()*l;
            int x_int = (int) Math.floor(x);
            int y_int = (int) Math.floor(y);
            
            if (xChosen.contains(x) || yChosen.contains(y)){
                continue;
            }

            if (peopleInCell.get(x_int).get(y_int) < 10){
                points.add(new CoordinatePair(x, y));
                peopleInCell.get(x_int).set(y_int, peopleInCell.get(x_int).get(y_int) + 1);
                xChosen.add(x);
                yChosen.add(y);
            }
        }
        return points;
    }

    public static void benchmarkAll(List<Integer> sizes){
        System.out.println("n,Brute Force,Divide and Conquer");
        for(int n : sizes){
            List<CoordinatePair> points = randomPoints(n);
            double distance = 0.5;
            benchmarkInput(points, distance);
        }
    }

    public static void benchmarkInput(List<CoordinatePair> points, double distance){
        int N = 10;
        if (points.size() < 1000) {
            N = (int) 10000.0 / points.size();
        }
        List<Long> bfTimes = new ArrayList<>();
        List<Long> dcTimes = new ArrayList<>();

        for (int i = 0; i < 2*N; i++) {
            long start = System.nanoTime();
            BruteForce.closePairs(points, distance);
            bfTimes.add(System.nanoTime() - start);
        }

        for (int i = 0; i < 2*N; i++) {
            long start = System.nanoTime();
            DivideAndConquer.closePairs(points, distance, 40);
            dcTimes.add(System.nanoTime() - start);
        }

        long bfTime = Math.round(bfTimes.subList(N, 2*N).stream().mapToLong(Long::longValue).average().getAsDouble());
        long dcTime = Math.round(dcTimes.subList(N, 2*N).stream().mapToLong(Long::longValue).average().getAsDouble());
        System.out.println(points.size() + "," + bfTime + "," + dcTime);
    }
}
