#!/bin/bash

if [ $# -eq 0 ]; then
  echo "USAGE: ./download_lectures [LECTURES]..."
  exit 1
fi

for lecture in $@; do
  if [ -d "lecture$lecture" ]; then
    echo "Directory lecture$lecture already exists"
  else
    echo "Creating new directory lecture$lecture"
    wget -q http://courses.cs.washington.edu/courses/cse391/20au/lectures/$lecture/lecture$lecture.zip
    unzip -q lecture"$lecture".zip
    rm lecture"$lecture".zip
  fi
done
