#!/bin/bash

# This script downloads and unzips lecture files for one or more lectures
# specified by the given command line arguments
#
# Usage: ./download_lectures.sh [LECTURES...]
#
# For example
#   ./download_lectures.sh 2 4
# will download the lecture files for lectures 2 and 4, putting each in
# their own directory.

if [ $# -eq 0 ]; then
  >&2 echo "Usage: ./download_lectures_final.sh [LECTURES...]"
  exit 1
fi

for num in $@; do
  if [ -d $num ]; then
    echo "Directory $num already exists!"
  else
    mkdir $num
    cd $num
    echo "Downloading Lecture $num files..."
    wget -q http://courses.cs.washington.edu/courses/cse391/20wi/lectures/${num}/lec0${num}Files.zip
    unzip -q lec0${num}Files.zip
    echo "Files in $(pwd):"
    ls
    cd ..
  fi
  echo
done

