#!/bin/bash

if [ $# -eq 0 ]; then
  echo "USAGE: ./download_lectures [LECTURES...]"
  exit 1
fi

for lecture in $@; do
  if [ -d $lecture ]; then
    echo "Directory $lecture already exists"
  else
    echo "Creating new directory $lecture"
    wget -q http://courses.cs.washington.edu/courses/cse391/20sp/lectures/$lecture/lec0"$lecture"Files.zip
    unzip -q lec0"$lecture"Files.zip
    rm lec0"$lecture"Files.zip
  fi
done
