import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.RecursiveTask;

public class MatrixMultiply {
    static ForkJoinPool POOL = new ForkJoinPool();
    static int CUTOFF;

    // Behavior should match Sequential.multiply.
    // Ignoring the initialization of arrays, your implementation should have n^3
    // work and log(n) span
    public static double[][] multiply(double[][] a, double[][] b, int cutoff) {
        MatrixMultiply.CUTOFF = cutoff;
        double[][] product = new double[a.length][b[0].length];
        POOL.invoke(new MatrixMultiplyAction()); // TODO: add parameters to match your constructor
        return product;
    }

    // Behavior should match the 2d version of Sequential.dotProduct.
    // Your implementation must have linear work and log(n) span
    public static double dotProduct(double[][] a, double[][] b, int row, int col, int cutoff) {
        MatrixMultiply.CUTOFF = cutoff;
        return POOL.invoke(new DotProductTask()); // TODO: add parameters to match your constructor
    }

    private static class MatrixMultiplyAction extends RecursiveAction {
        // TODO: select fields

        public MatrixMultiplyAction() {
            // TODO: implement constructor
        }

        public void compute() {
            // TODO: implement
        }

    }

    private static class DotProductTask extends RecursiveTask<Double> {
        // TODO: select fields

        public DotProductTask() {
            // TODO: implement constructor
        }

        public Double compute() {
            // TODO: implement
            return 0.0;
        }
    }
}
