import React, {Component} from 'react';

class Buggy extends Component {

    constructor(props) {
        super(props);
        this.canvasRef = React.createRef();
        this.state = {
            color: "purple"
        };
    }

    drawSquare() {
        let context = this.canvasRef.current.getContext("2d");
        context.fillStyle = this.state.color;
        context.fillRect(10, 10, 180, 180);
    }

    setGreen = () => {
        this.setState({
            color: "green"
        });
        this.drawSquare();
    };

    setRed = () => {
        this.setState({
            color: "red"
        });
        this.drawSquare();
    };

    setBlue = () => {
        this.setState({
            color: "blue"
        });
        this.drawSquare();
    };

    render() {
        return (
            <div>
                <p>Current Color: {this.state.color}</p>
                <button onClick={this.setGreen}>Green</button>
                <button onClick={this.setRed}>Red</button>
                <button onClick={this.setBlue}>Blue</button>
                <br/>
                <canvas ref={this.canvasRef} width="200" height="200"></canvas>
            </div>
        );
    }

}

export default Buggy;
