package simpleParser.complete;

import com.opencsv.CSVReader;

import java.io.*;
import java.nio.file.Files;
import java.nio.file.Paths;

/**
 * This class is part of a demo to demonstrate how csv data can be parsed using Java
 * This class uses the CSVReader to read a CSV file and read the file line by line
 */
public class SimpleParser {

    /**
     * The path of the csv from the root
     */
    private static final String CSV_FILENAME = "users.csv";

    /**
     * This method reads the csv file and prints out the data from the file after
     * reading the file line by line
     *
     * @param args
     */
    public static void main(String[] args) {
        try {

            InputStream stream = SimpleParser.class.getResourceAsStream("/data/" + CSV_FILENAME);
            if(stream == null) {
                System.err.println("File not found: " + CSV_FILENAME);
                System.exit(1);
            }
            Reader reader = new BufferedReader(new InputStreamReader(stream));

            CSVReader csvReader = new CSVReader(reader);

            // Reading Records One by One in a String array
            String[] nextRecord;
            while((nextRecord = csvReader.readNext()) != null) {
                System.out.println("Name : " + nextRecord[0]);
                System.out.println("Email : " + nextRecord[1]);
                System.out.println("==========================");
            }
        } catch(IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}
