package parseInteresting.complete;

import com.opencsv.bean.CsvBindByName;

/**
 * This is the Java representation of a UFO Sighting
 */
public class UfoSightingModel {

    /**
     * city where the UFO sighting occurred
     */
    @CsvBindByName
    private String city;

    /**
     * state where the UFO sighting occurred
     */
    @CsvBindByName
    private String state;

    /**
     * country where the UFO sighting occurred
     */
    @CsvBindByName
    private String country;

    /**
     * shape of the sighted UFO
     */
    @CsvBindByName
    private String shape;

    /**
     * comments regarding the sighting
     */
    @CsvBindByName
    private String comments;

    /**
     * get the city of the sighting
     *
     * @return city of the sighting
     */
    public String getCity() {
        return city;
    }

    /**
     * set the city of the sighting
     *
     * @param city of the sighting
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * get the state of the sighting
     *
     * @return state of the sighting
     */
    public String getState() {
        return state;
    }

    /**
     * set the state of the sighting
     *
     * @param state of the sighting
     */
    public void setState(String state) {
        this.state = state;
    }

    /**
     * get the country of the sighting
     *
     * @return country of the sighting
     */
    public String getCountry() {
        return country;
    }

    /**
     * set the country of the sighting
     *
     * @param country of the sighting
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /**
     * get the shape of the UFO sighted
     *
     * @return shape of the UFO sighted
     */
    public String getShape() {
        return shape;
    }

    /**
     * set the shape of the UFO sighted
     *
     * @param shape of the UFO sighted
     */
    public void setShape(String shape) {
        this.shape = shape;
    }

    /**
     * get the comments relating to the sighting
     *
     * @return the comments relating to the sighting
     */
    public String getComments() {
        return comments;
    }

    /**
     * set the comments relating to the sighting
     *
     * @param comments relating to the sighting
     */
    public void setComments(String comments) {
        this.comments = comments;
    }
}
