package parseInteresting;

import com.opencsv.bean.CsvToBean;
import com.opencsv.bean.CsvToBeanBuilder;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;

/**
 * This class is part of a demo to demonstrate how csv data can be parsed using Java
 * This class uses the CSVReader to read a CSV file and read the file line by line
 * This part of the demo will use UfoSightingModel.java and will create an object for each line
 * The created objects will then be used to look at aggregate data trends and information
 */
public class UfoDataParser {

    /**
     * The path of the csv from the root
     */
    private static final String CSV_FILENAME = "ufo-data.csv";

    /**
     * Reads the csv file and analyzes the aggregate data
     *
     * @param args
     */
    public static void main(String[] args) {
        InputStream stream = UfoDataParser.class.getResourceAsStream("/data/" + CSV_FILENAME);
        if(stream == null) {
            System.err.println("File not found: " + CSV_FILENAME);
            System.exit(1);
        }
        Reader reader = new BufferedReader(new InputStreamReader(stream));
        //
        CsvToBean<UfoSightingModel> csvToBean = new CsvToBeanBuilder<UfoSightingModel>(reader)
                .withType(UfoSightingModel.class)
                .withIgnoreLeadingWhiteSpace(true)
                .build();

        Iterator<UfoSightingModel> csvUserIterator = csvToBean.iterator();

        // TODO: Perform aggregatations on the collected data
    }
}
