# Your file header here!

import networkx as nx
# Your other import(s) here!

FACEBOOK_PATH = "facebook-links-small.txt"


def read_facebook(facebook: nx.Graph, filename: str) -> None:
    """
    Given a graph and file path, this function reads in
    the file path and adds every entry as an edge in the graph.
    """
    with open(filename) as f:
        for row in f:
            items = row.split()
            person1, person2 = items[0], items[1]
            facebook.add_edge(int(person1), int(person2))


def friends(graph: nx.Graph, user: int) -> set[int]:
    """
    Returns a set of the friends of the given user, in the given graph.
    """
    return set(graph.neighbors(user))


def friends_of_friends(graph: nx.Graph, user: int) -> set[int]:
    """
    Finds and returns a set of the friends of friends of the given user
    in the given graph
    """
    f_of_f = set()
    user_friends = friends(graph, user)
    for friend in user_friends:
        f_of_f = f_of_f | friends(graph, friend)
    return f_of_f - user_friends - set([user])


# Your code here!


def main():
    g = nx.Graph()
    read_facebook(g, FACEBOOK_PATH)

    # Your code here!


if __name__ == '__main__':
    main()
