# Replace this line with a descriptive file header!

def total(n):
    """
    Returns the sum of the numbers from 0 to n (inclusive).
    If n is negative, returns None.
    """
    if n <= 0:
        return None
    else:
        result = 0
        for i in range(n):
            result += i
        return result


def median(numbers):
    """
    Given a sorted list of numbers, returns the median.
    """
    n = len(numbers)

    result = None
    if len(numbers) % 2 == 0:
        result = numbers[n // 2]
    else:
        upper_num = numbers[n // 2]
        lower_num = numbers[n // 2 - 1]
        result = (upper_num + lower_num) / 2

    return result


def five_number_summary(numbers):
    """
    Given a sorted list of numbers, returns a tuple of the five-number
    summary: the minimum, first quartile, median, third quartile,
    and maximum.
    """
    n = len(numbers)

    if n % 2 == 0:
        lower_half = numbers[:n // 2]
        upper_half = numbers[n // 2:]
    else:
        lower_half = numbers[:n // 2]
        upper_half = numbers[n // 2 + 1:]

    return numbers[0], median(lower_half), median(numbers), median(upper_half), numbers[-1]

# Write and document your other functions here!
