"""
Suh Young Choi
CSE 163
Lesson 13: Course

This file contains the Course class, which represents
a course at the University of Washington.
"""


class Course:
    """
    Represents a course with a course code,
    credit hours, instructor, and prerequisite list.
    """
    def __init__(self, code: str, credit_hours: int, 
                 instructor: str, prereqs: list[str]) -> None:
        """
        Creates a Course object from the given course code,
        credit hours, instructor name, and list of prerequisites
        """
        self._code: str = code
        self._credit_hours: int = credit_hours
        self._instructor: str = instructor
        self._prereqs: list[str] = prereqs

    def get_name(self) -> str:
        """
        Returns the string name of the course
        """
        return self._code

    def get_prereqs(self) -> list[str]:
        """
        Returns a list of strings representing the
        prerequisites of the course
        """
        return self._prereqs

    def get_credit_hours(self) -> int:
        """
        Returns the integer credit hours of the course
        """
        return self._credit_hours

    def check_instructor(self, other: "Course") -> bool:
        """
        Given another course object, returns whether both
        courses have the same instructor
        """
        return self._instructor == other._instructor
