import sys
import os
from utils import convert_to_grayscale

if __name__ == "__main__":
    if len(sys.argv) == 2:
        input_file = sys.argv[1]
        path_without_ext, ext = os.path.splitext(input_file)
        input_filename = os.path.basename(path_without_ext)
        out_file = input_filename + '_BW.png'

        convert_to_grayscale(input_file, out_file)
        print(f"Converted {input_file} to grayscale and saved as {out_file}")
    else:
        print("Usage: python color_to_gray.py <input_file>")
        sys.exit(1)
