import pandas as pd


def collect_state_data(state):
    data = pd.read_csv("all-states-history.csv")
    df = data[["date", "state", "positiveIncrease"]]
    df = df[df["state"] == state].copy()
    df["date"] = pd.to_datetime(df["date"])
    df = df.set_index("date")
    df.rename(columns={"positiveIncrease": "positive"}, inplace=True)
    df = df["positive"].resample("ME").agg({"positive": "sum"}).dropna()
    df["positive"] = df["positive"].astype(int)
    df.index = df.index.strftime("%Y-%m")
    df = df.reset_index()
    list_data = df.to_dict("records")
    ys = []
    for row in list_data:
        ys.append(row["positive"])
    return ys[:13]
