import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class TreeFrame {
    private JFrame frame;
    private JTextArea text;
    private TreePanel treePanel;
    private JSlider slider;
    private JTextField input;

    public TreeFrame() {
        frame = new JFrame();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(800, 600);
        Container c = frame.getContentPane();
        int initialDelay = addSouthPanel(c);
        addNorthPanel(c);
        treePanel = new TreePanel(text, initialDelay);
        c.add(treePanel, BorderLayout.CENTER);
    }

    public void addNorthPanel(Container c) {
        JPanel north = new JPanel(new GridLayout(1, 2));
        c.add(north, BorderLayout.NORTH);

        JPanel left = new JPanel();
        north.add(left);
        input = new JTextField(10);
        left.add(input);
        JButton b = new JButton("add");
        ActionListener addAction = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                String s = input.getText().trim();
                if (s.length() > 0) {
                    treePanel.add(input.getText());
                    input.setText("");
                }
            }
        };
        b.addActionListener(addAction);
        input.addActionListener(addAction);
        left.add(b);
        b = new JButton("clear");
        b.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                treePanel.clear();
            }
        });
        left.add(b);

        JPanel right = new JPanel();
        north.add(right);
        b = new JButton("preorder");
        b.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                treePanel.preorderTraversal();
            }
        });
        right.add(b);
        b = new JButton("inorder");
        b.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                treePanel.inorderTraversal();
            }
        });
        right.add(b);
        b = new JButton("postorder");
        b.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                treePanel.postorderTraversal();
            }
        });
        right.add(b);
    }

    public int addSouthPanel(Container c) {
        JPanel south = new JPanel(new BorderLayout());
        text = new JTextArea(1, 30);
        text.setEditable(false);
        JPanel upper = new JPanel(new BorderLayout());
        upper.add(new JLabel("traversals: "), BorderLayout.WEST);
        upper.add(text, BorderLayout.CENTER);
        south.add(upper, BorderLayout.NORTH);
        c.add(south, BorderLayout.SOUTH);

        // initialize delay and add slider to control it at bottom
        final int maxPause = 3000; // milliseconds
        slider = new JSlider(0, maxPause - 500);
        int initialDelay = maxPause - slider.getValue();
        slider.addChangeListener(new ChangeListener() {
                public void stateChanged(ChangeEvent e) {
                    int delay = maxPause - slider.getValue();
                    treePanel.setDelay(delay);
                }
            });
        JPanel p = new JPanel();
        p.add(new JLabel("slow"));
        p.add(slider);
        p.add(new JLabel("fast"));
        south.add(p, BorderLayout.SOUTH);
        return initialDelay;
    }

    public void start() {
        frame.setVisible(true);
    }
}
