public class RecursiveProgramming {
    public static void main(String[] args) {
        System.out.println("Iterative Approach");
        iterativeFactorialPrint(5);

        System.out.println();
    
        // System.out.println("Recursive Approach");
        // recursiveFactorialPrint(5, "");
    }

    // Iterative implementation of factorial:
    //      n! = n * (n-1) * (n-2) * ... * 2 * 1
    public static int iterativeFactorial(int n) {
        int result = 1;
        
        for (int i = n; i > 1; i--) {
            result *= i;
        }
        return result;
    }
    
    public static int iterativeFactorialPrint(int n) {
        int result = 1;
        
        System.out.print(n + "! = ");
        for (int i = n; i > 1; i--) {
            result *= i;
            System.out.print(i + " * ");
        }
        System.out.println("1 = " + result);
        return result;
    }

    // Recursive implementation of factorial:
    //      n! = n * (n-1)!
    public static int recursiveFactorial(int n) {
        if (n == 0) {
            // Base case
            return 1;
        } else {
            // Recursive case            
            int nMinusOne = recursiveFactorial(n - 1);
            int total = n * nMinusOne;
            
            return total;
        }
    }

    public static int recursiveFactorialPrint(int n, String indent) {
        if (n == 0) {
            // Base case
            System.out.println(indent + "0! = 1 <- Base Case");
            return 1;
        } else {
            // Recursive case
            System.out.println(indent + n + "! = " + n + " * " + (n - 1) + "!");
            
            int nMinusOne = recursiveFactorialPrint(n - 1, indent + "    ");
            int total = n * nMinusOne;
            
            System.out.println(indent + n + "! = " + n + " * " + nMinusOne + " = " + total);
            return total;
        }
    }

    // TODO: Implement an iterative method that calculates of x^n
    //       (don't use Math.pow). You don't need to worry about
    //       printing things out like we do above
    public static int iterativeExponent(int x, int n) {
        return -1;
    }

    // TODO: Implement a recursive method that calculates of x^n
    //       (don't use Math.pow). You don't need to worry about
    //       printing things out like we do above
    public static int recursiveExponent(int x, int n) {
        return -1;
    }

    // TODO: Implement a recursive method that calculates the nth term
    //       of the fibonacci sequence. This is a sequence of numbers
    //       where a term is determined by summing the two previous terms:
    //       0, 1, 1, 2, 3, 5, 8, 13, 21, ...
    //
    //       Note that the third term (1) is calculated by summing together the
    //       first (0) and second (1) terms.
    public static int fibonacci(int n) {
        return -1;
    }
}
