// This class represents a HealthcareWorker at 
// a particular hospital. It extends the Employee class. 
public class HealthcareWorker extends Employee {
    private String hospital;

    // Constructs a healthcare worker whose assigned hospital
    // is the given hospital.
    public HealthcareWorker(String name, String hospital) {
        super(name);
        this.hospital = hospital;
    }

    // Returns this healthcare worker's hospital.
    public String getHospital() {
        return hospital;
    }

    // Returns a string representation of this healthcare worker,
    // including what hospital they work at.
    public String toString() {
        return "Healthcare Worker at " + hospital;
    }
}
