// This class represents a doctor at 
// a particular hospital. It extends the HealthcareWorker class. 
public class Doctor extends HealthcareWorker {
    
    // Constructs a Nurse whose assigned hospital
    // is the given hospital.
    public Doctor(String name, String hospital) {
        super(name, hospital);
    }

    // Returns this employees hourly pay rate.
    public double getHourlyRate() {
        return 2 * super.getHourlyRate();
     }    

    // Prints out that this doctor is taking pulse.
    public void takePulse() {
        System.out.println("Taking pulse");
    }


    // Prints out that this doctor is taking the pulse
    // of the given patient.
    public void takePulse(String patient) {
        System.out.println("Taking pulse for " + patient);
    }

    // Returns a string representation of this Doctor,
    // including what hospital they work at.
    public String toString() {
        return "Doctor at " + getHospital();
    }
}
