// Represents a list of integers.
public class LinkedIntList {
    private ListNode front;

    // Post: Returns the total number of values present within this list
    public int size() {
        return size(this.front);
    }

    // Post: Returns the total number of values present within the sublist rooted at front
    private int size(ListNode front) {
        if (front == null) {
            return 0;
        } else {
            return 1 + size(front.next);
        }
    }

    // Post: Returns whether or not the provided value is present within this list
    public boolean contains(int value) {
        return contains(value, this.front);
    }

    // Post: Returns whether or not the provided value is present within the sublist rooted at front
    private boolean contains(int value, ListNode front) {
        if (front == null) {
            return false;
        } else {
            return front.data == value || contains(value, front.next);
        }
    }

    // post: Adds the given value at the given index of this list
    //       throws an IllegalArgumentException if the index is out of bounds
    public void add(int index, int value) {
        if (index < 0 || index > size()) {
            throw new IllegalArgumentException("Provided index invalid: " + index);
        }

        front = add(index, value, front);
        
        // if (index == 0) {
        //     this.front = new ListNode(value, this.front);
        // } else {
        //     ListNode curr = front;
        //     while (index != 1) {
        //         index--;
        //         curr = curr.next;
        //     }
        //     curr.next = new ListNode(value, curr.next);
        // }
    }

    private ListNode add(int index, int value, ListNode curr) {
        if (index == 0) {
            curr = new ListNode(value, curr);
        } else {
            curr.next = add(index - 1, value, curr.next);
        }
        return curr;
    }

    // Post: Returns a space-separated string representation of this list
    @Override
    public String toString() {
        return toString(this.front);
    }

    // Post: Returns a space-separated string representation of the sublist rooted at front
    private String toString(ListNode front) {
        if (front == null) {
            return "";
        } else {
            return front.data + " " + toString(front.next);
        }
    }

    // Post: Replaces the all occurences of toReplace in this list with newValue
    public void replaceAll(int toReplace, int newValue) {
        this.front = replaceAll(toReplace, newValue, this.front);
    }

    // Post: Replaces the all occurences of toReplace in the sublist rooted at current with newValue
    private ListNode replaceAll(int toReplace, int newValue, ListNode current) {
        if (current == null) {
            return null;
        } else if (current.data == toReplace) {
            return new ListNode(newValue, replaceAll(toReplace, newValue, current.next));
        } else {
            current.next = replaceAll(toReplace, newValue, current.next);
            return current;

        }
    }

    // Pre:  Assumes provided array is not null
    // Post: Converts the given array into a LinkedIntList
    public LinkedIntList(int[] arr) {
        this.front = arrHelper(arr, 0);
    }

    // Pre:  Assumes provided array is not null
    // Post: Converts the given array starting at the given index into a sublist which is then returned
    private ListNode arrHelper(int[] arr, int i) {
        if (i == arr.length) {
            return null;
        } else {
            return new ListNode(arr[i], arrHelper(arr, i + 1));
        }
    }

    // Inner class that represents a single node containing an
    // integer value.
    private static class ListNode {
        public final int data;
        public ListNode next;
        
        // Constructs a ListNode with the given data
        public ListNode(int data) {
            // Sets the next field to null, meaning there
            // is no next linked node.
            this(data, null);
        }
        
        // Constructs a ListNode with the given data
        // and given next node.
        public ListNode(int data, ListNode next) {
            this.data = data;
            this.next = next;
        }
    }
}
