// This class represents a tree of integers
public class IntTree {
    private IntTreeNode overallRoot;

    // Post: Constructs a basic tree based on the diagram in the Ed lesson
    public IntTree() {
        overallRoot = new IntTreeNode(6);
        overallRoot.left = new IntTreeNode(3);
        overallRoot.left.left = new IntTreeNode(1);
        overallRoot.left.right = new IntTreeNode(4);
        overallRoot.right = new IntTreeNode(2);
        overallRoot.right.left = new IntTreeNode(6);
        overallRoot.right.right = new IntTreeNode(4);
    }

    // Post: Returns the total number of values present within the tree
    public int size() {
        // TODO: Implement this!
        return -1;
    }

    // Post: Returns whether or not the provided value is present within the tree
    public boolean contains(int value) {
        // TODO: Implement this!
        return false;
    }

    // Post: Returns a pre-order string representation of the current tree
    @Override
    public String toString() {
        return "";
    }

    public void printPreOrder() {
        printPreOrder(overallRoot);
    }

    private void printPreOrder(IntTreeNode root) {
        if (root != null) {
            System.out.print(root.data + " ");
            printPreOrder(root.left);
            printPreOrder(root.right);
        }
    }

    public void printInOrder() {
        printInOrder(overallRoot);
    }
    
    private void printInOrder(IntTreeNode root) {
        if (root != null) {
            printInOrder(root.left);
            System.out.print(root.data + " ");
            printInOrder(root.right);
        }
    }

    public void printPostOrder() {
        printPostOrder(overallRoot);
    }
    
    private void printPostOrder(IntTreeNode root) {
        if (root != null) {
            printPostOrder(root.left);
            System.out.print(root.data + " ");
            printPostOrder(root.right);
        }
    }

    // Post: Replaces the all occurences of toReplace in the tree with newValue
    public void replaceAll(int toReplace, int newValue) {
        // TODO: Implement this!
    }

    // Pre:  Assumes provided array is not null
    // Post: Constructs a basic tree based on the provided array, where values are provided
    //       left-to-right from the root of the tree to the leaves
    public IntTree(Integer[] arr) {
        // TODO: Implement this!
    }

    // Class that represents a single node in the tree
    private static class IntTreeNode {
        public final int data; // data stored at this node
        public IntTreeNode left; // reference to left subtree
        public IntTreeNode right; // reference to right subtree

        // Constructs a leaf node with the given data.
        public IntTreeNode(int data) {
            this(data, null, null);
        }

        // Constructs a leaf or branch node with the given data and links.
        public IntTreeNode(int data, IntTreeNode left, IntTreeNode right) {
            this.data = data;
            this.left = left;
            this.right = right;
        }
    }
}
