// LinkedIntList.java
// Represents a list of integers.
public class LinkedIntList implements IntList {
    private ListNode front;
    
    // post: constructs an empty LinkedIntList
    public LinkedIntList() {
        this(null);
    }

    // post: returns the number of elements in this list
    public int size() {
        // int size = 0;
        // ListNode curr = front;
        // while (curr != null) {
        //     size++;
        //     curr = curr.next;
        // }
        // return size;
        return size(front);
    }

    private int size(ListNode curr) {
        if (curr == null) {
            return 0;
        } else {
            return 1 + size(curr.next);
        }
    }

    // post: returns the index of the first occurence of the provided value
    //       within this list, -1 if not present
    public int indexOf(int value) {
        // int index = 0;
        // ListNode curr = front;
        // while (curr != null) {
        //     if (curr.data == value) {
        //         return index;
        //     }
        //     index++;
        //     curr = curr.next;
        // }
        // return -1;
        return indexOf(value, front, 0);
    }

    private int indexOf(int value, ListNode curr, int index) {
        if (curr == null) {
            return -1;
        } else if (curr.data == value) {
            return index;
        } else {
            return indexOf(value, curr.next, index + 1);
        }
    }

    public int countGreaterThan(int boundary) {
        int count = 0;
        ListNode curr = front;
        while (curr != null) {
            if (curr.data > boundary) {
                count++;
            }
            curr = curr.next;
        }
        return count;
    }

    // post: prints out this list's values separated by spaces
    public void printList() {
        // From last class
        while (front != null) {
            System.out.println(front.data + " ");
            front = front.next;
        }
    }

    // post: returns a comma-separated String representation of this list
    //       surrounded by square brackets
    public String toString() {
        if (this.front == null) {
            return "[]";
        }
        String ret = "[" + this.front.data;
        ListNode curr = this.front.next;
        while (curr != null) {
            ret += ", " + curr.data;
            curr = curr.next;
        }
        return ret + "]";
    }

    // post: Adds the given value to the end of this list
    public void add(int value) {
        add(size(), value);
    }

    // post: Adds the given value at the given index of this list
    //       throws an IllegalArgumentException if the index is out of bounds
    public void add(int index, int value) {
        if (index < 0 || index > size()) {
            throw new IllegalArgumentException("Provided index invalid: " + index);
        }
        
        if (index == 0) {
            this.front = new ListNode(value, this.front);
        } else {
            ListNode curr = front;
            while (index != 1) {
                index--;
                curr = curr.next;
            }
            curr.next = new ListNode(value, curr.next);
        }
    }

    // post: returns the value of the element at the given int index of the list
    //       throws an IllegalArgumentException if the index is out of bounds
    public int get(int index) {
        if (index < 0 || index >= size()) {
            throw new IllegalArgumentException("Provided index invalid: " + index);
        }
        ListNode curr = front;
        while (index != 0) {
            curr = curr.next;
            index--;
        }
        return curr.data;
    }

    // post: removes all occurences of the given value from the list.
    public void removeAll(int value) {
        // while (this.front != null && this.front.data == value) {
        //     this.front = this.front.next;
        // }

        // ListNode curr = front;
        // while (curr != null && curr.next != null) {
        //     if (curr.next.data == value) {
        //         curr.next = curr.next.next;
        //     } else {
        //         curr = curr.next;
        //     }
        // }
        front = removeAll(value, front);  // x = change(x)
    }
    
    private ListNode removeAll(int value, ListNode node) {
        if (node == null) {
            return node;
        } else if (node.data == value) {
            return removeAll(value, node.next);
        } else {
            node.next = removeAll(value, node.next);  // x = change(x)
            return node;
        }
    }

    // post: constructs a LinkedIntList from the given int[] nums
    //       constructs an empty LinkedIntList if nums is null or has a size of 0
    public LinkedIntList(int[] nums) {
        if (nums != null) {
            for (int i = 0; i < nums.length; i++) {
                this.add(i, nums[i]);
            }
        }
    }

    // Inner class that represents a single node containing an
    // integer value.
    private static class ListNode {
        public final int data;
        public ListNode next;
        
        // Constructs a ListNode with the given data
        public ListNode(int data) {
            // Sets the next field to null, meaning there
            // is no next linked node.
            this(data, null);
        }
        
        // Constructs a ListNode with the given data
        // and given next node.
        public ListNode(int data, ListNode next) {
            this.data = data;
            this.next = next;
        }
    }
}
