// Timer represents a class capable of tracking the duration of
// certain operations
public class Timer {
    private Long start;
    private Long end;

    // Returns whether or not the timer has been started
    public boolean started() {
        return start != null;
    }

    // Returns whether or not the timer has been stopped
    public boolean stopped() {
        return end != null;
    }

    // Resets the current timer
    public void reset() {
        this.start = null;
        this.end = null;
    }

    // Starts the current timer
    public void start() {
        if (this.start == null && this.end == null) {
            this.start = System.nanoTime();
        }
    }

    // Stops the current timer
    public void stop() {
        if (start != null) {
            this.end = System.nanoTime();
        }
    }

    // Returns the total elapsed time between start() and stop() calls
    // Throws an IllegalStateException if the timer has not been started then stoppped
    public double getTime() {
        if (start == null) {
            throw new IllegalStateException("Timer not started");
        } else if (end == null) {
            throw new IllegalStateException("Timer not stopped");
        }

        return (double)(end - start) / 1_000_000_000.0;
    }

    // Given a total number of seconds 'totalTime', resturns the total time in
    // the form "1:20.05s"
    public static String getTimeFormatted(double totalTime) {
        int mins = (int) totalTime / 60;
        double secs = totalTime % 60;
        secs = ((int) (secs * 100)) / 100.0;
        return mins + ":" + ((secs < 10) ? "0" : "") + secs + "s";                  
    }
}
