import java.util.*;
import java.io.*;

public class Scrabble {
    private static int recursiveCalls;

    public static void main(String[] args) {
        Set<String> dictionary = loadDictionary();
        List<Character> letters = readLetters();

        Timer timer = new Timer();
        timer.start();
        recursiveCalls = 0;
        String best = findBestWord(letters, dictionary);
        timer.stop();
        System.out.println(best + " (" + scoreWord(best) + ")");
        System.out.println("Found in " + recursiveCalls + " calls; took " + timer.getTime() + "s");
    }

    public static String findBestWord(List<Character> letters, Set<String> dict) {
        return null;
    }

    // HELPER METHODS

    private static boolean couldWork(String prefix, Set<String> dict) {
        for (String word : dict) {
            if (word.startsWith(prefix)) {
                return true;
            }
        }
        return false;
    }

    // does not check if word is legal
    private static int scoreWord(String word) {
        if (word == null) {
            return 0;
        }

        //              A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q,  R, S, T, U, V, W, X, Y, Z
        int[] values = {1, 3, 3, 2, 1, 4, 2, 4, 1, 8, 5, 1, 3, 1, 1, 3, 10, 1, 1, 1, 1, 4, 4, 8, 4, 10};

        int score = 0;
        word = word.toUpperCase();
        for (int i = 0; i < word.length(); i++) {
            char ch = word.charAt(i);
            score += values[ch - 'A'];
        }

        return score;
    }

    private static List<Character> readLetters() {
        List<Character> result = new ArrayList<>();

        Scanner input = new Scanner(System.in);
        System.out.print("Enter letters separated by whitespace: ");
        Scanner letters = new Scanner(input.nextLine());
        while (letters.hasNext()) {
            String letter = letters.next();
            if (letter.length() > 1) {
                System.out.println("  Skipping " + letter + " - not one letter");
            } else {
                result.add(letter.toUpperCase().charAt(0));
            }
        }

        return result;
    }

    private static Set<String> loadDictionary() {
        try {
            Scanner input = new Scanner(new File("dictionary.txt"));
            Set<String> dict = new HashSet<>();

            while (input.hasNextLine()) {
                dict.add(input.nextLine());
            }

            return dict;
        } catch (Exception e) {
            return null;   
        }
    }
}
