import java.util.*;

// PasswordGenerator generates a secret password which can then be guessed at
public class PasswordGenerator {
    public static final Random RAND = new Random();
    public static final String CHARS = "1234567890" /* nums */
                                    //  + "abcdefghijklmnopqrstuvwxyz" /* alpha */
                                    //  + "ABCDEFGHIJKLMNOPQRSTUVWXYZ" /* caps */
                                    //  + "!@#$%^&*()-_=+`~[]{}\\|;:'\",.<>/?" /* special */
                                     ;
    private int length;
    private String password;

    private static final int MAX = 15;  // Maximum number of digits in default password
    private static final int MIN = 8;   // Minimum number of digits in default password

    // Constructs a new PasswordGenerator storing a default password
    public PasswordGenerator() {
        this(MIN + RAND.nextInt(MAX - MIN) + 1);
    }

    // Constructs a new PasswordGenerator storing a password with the given length
    public PasswordGenerator(int length) {
        this.length = length;
        this.password = "";
        for (int i = 0; i < length; i++) {
            password += CHARS.charAt(RAND.nextInt(CHARS.length()));
        }
    }

    // Returns the length of this password
    public int getLength() {
        return this.length;
    }

    // Returns the sum of all digits within the password
    // Throws an IllegalStateException if the password contains characters that aren't nums
    public int sum() {
        int sum = 0;
        for (int i = 0; i < password.length(); i++) {
            char c = password.charAt(i);
            if (!Character.isDigit(c)) {
                throw new IllegalStateException("Trying to get sum of password " +
                                                "containing non-numeric char: " + c);
            }

            sum += Character.getNumericValue(c);
        }
        return sum;
    }


    // Returns whether or not the given password matches the secret internal one
    public boolean check(String guess) {
        // try {
        //     Thread.sleep(1);
        // } catch (InterruptedException ex) { }
        
        return password.equals(guess);
    }
}
