
//
// Note: This application can take a good while to finish excecuting
//       with difficult passwords 

public class PasswordCracker {
    private Timer all;
    private Timer correct;

    // Constructs a new PasswordCracker
    public PasswordCracker() {
        this.all = new Timer();
        this.correct = new Timer();
    }

    // Returns the total time it took to guess all possible passwords
    // Throws an IllegalStateException if 'crack' has not been called
    public double getAllTime() {
        return all.getTime();
    }

    // Returns the total time it took to guess the correct password
    // Throws an IllegalStateException if 'crack' has not been called
    public double getCorrectTime() {
        return correct.getTime();
    }

    // Given a PasswordGenerator, systematically guesses all possible passwords
    // until the correct one is determined, printing out the result
    public void crack(PasswordGenerator generator) {
        all.start();
        correct.start();
        crack(generator, "");
        all.stop();
    }
    
    private void crack(PasswordGenerator generator, String soFar){
        // base case
        if(soFar.length() == generator.getLength()){
            if(generator.check(soFar)){
                System.out.println(soFar);
                correct.stop();
            }
        } else{
            // recursive case
            for(int i = 0; i < PasswordGenerator.CHARS.length();i++){
                char next = PasswordGenerator.CHARS.charAt(i);
                crack(generator, soFar + next);
            }
        }
    }



}

