import org.junit.jupiter.api.*;
import static org.junit.jupiter.api.Assertions.*;
import java.util.*;

public class Testing {

    @Test
    @DisplayName("Book string, list constructor")
    public void testBookStringList() {
        Book book = new Book("Title", List.of("Author 1", "Author 2"), new Scanner("Content"));

        // TODO: Change the following to test that getTitle returns "Title"
        assertEquals("Title", null);

        // TODO: Change the following to test that getArtists returns a list
        //       containing "Author 1" and "Author 2"
        assertEquals(List.of("Author 1", "Author 2"), null);

        // TODO: Change the following to test that toString returns the correctly
        //       String representation
        assertEquals("Title by [Author 1, Author 2]", null);

        // TODO: Change the following to test that getContent returns a list containing "Content"
        assertEquals(List.of("Content"), null);
    }

    @Test
    @DisplayName("getNumRatings")
    public void testNumRatings() {
        Book book = new Book("Title", List.of("Author"), new Scanner("Content"));
        
        assertEquals(0, book.getNumRatings());

        book.addRating(1);
        // TODO: Test that getNumRatings returns 1


        book.addRating(1);
        // TODO: Test that getNumRatings returns 2

        
    }

    @Test
    @DisplayName("getAvgRating")
    public void testAvgRatings() {
        Book book = new Book("Title", List.of("Author"), new Scanner("Content"));
        // TODO: Test that getAverageRating returns 0
        

        book.addRating(4);
        // TODO: Test that getAverageRating returns 4


        book.addRating(5);
        // TODO: Test that getAvgRating returns 4.5

        
    }

    @Test
    @DisplayName("createIndex tests")
    public void testInvertedIndex() {
        Book mistborn = new Book("Mistborn", List.of("Brandon Sanderson"),
                                 new Scanner("Epic fantasy worldbuildling content"));
        Book farenheit = new Book("Farenheit 451", List.of("Ray Bradbury"),
                                  new Scanner("Realistic \"sci-fi\" content"));
        Book hobbit = new Book("The Hobbit", List.of("J.R.R. Tolkein"),
                               new Scanner("Epic fantasy quest content"));
        
        List<Media> books = List.of(mistborn, farenheit, hobbit);
        Map<String, Set<Media>> index = SearchClient.createIndex(books);
        
        // TODO: Finish the following statements by using assertTrue/assertFalse to test that the 
        //       quotes around sci-fi aren't ignored. Then uncomment it!
        // assert___(index.containsKey("sci-fi"));
        // assert___(index.containsKey("\"sci-fi\""));

        // TODO: Change what the 'expected' set contains such that the 
        //       assertEquals(expected, index.get("fantasy")) passes.
        // Hint: What original books include 'fantasy'?
        Set<Book> expected = Set.of(mistborn, farenheit, hobbit);
        assertEquals(expected, index.get("fantasy"));
    }
}
