import java.util.*;

// Represents a hash table capable of storing string values
public class StringHashSet implements Searchable {
    public static final int DEFAULT_CAPACITY = 10;
    
    private String[] hashTable;

    // Post: Constructs a new StringHashSet with DEFAULT_CAPACITY
    public StringHashSet() {
        this(DEFAULT_CAPACITY);
    }

    // Post: Constructs a new StringHashSet with the provided 'capacity' value
    public StringHashSet(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity: " + capacity);
        }
        
        this.hashTable = new String[capacity];
    }

    // Post: Copies all of the values within the provided list into this StringHashSet
    public void copy(List<String> values) {
        for (String x : values) {
            this.add(x);
        }
    }

    // Helper method: Converts calculates a hashCode for the provided value
    private int hashCode(String value) {
        int h = 0;
        for (int i = 0; i < value.length(); i++) {
            h = 31 * h + value.charAt(i);
        }
        return h;
    }

    // Helper method: Converts the provided value into an appropriate index lookup
    // in our internal hash table
    private int toIndex(String value) {
        return Math.abs(hashCode(value) % hashTable.length);
    }

    // Post: Adds the provided value to this StringHashSet
    public void add(String value) {
        // TODO: Implement!
    }

    // Post: Returns whether or not the provided value is present within this IntHashSet
    public boolean contains(String value) {
        // TODO: Implement!
        return false;
    }

}
